# 画面設計書 153-Cat ノード属性

## 概要

本ドキュメントは、OpenSearchのCat Node Attributes API（`GET /_cat/nodeattrs`）エンドポイントに関する画面設計書である。クラスタ内ノードのカスタムノード属性をテーブル形式で返すAPIの仕様を定義する。

### 本画面の処理概要

**業務上の目的・背景**：クラスタ内の各ノードに設定されたカスタム属性（node.attr.*）を一覧形式で確認するために使用される。アウェアネスルーティングやシャードアロケーションフィルタリングなどで設定されたノード属性の確認に有用であり、クラスタのトポロジ管理やデバッグに活用される。

**画面へのアクセス方法**：HTTPクライアントから `GET /_cat/nodeattrs` にリクエストを送信してアクセスする。

**主要な操作・処理内容**：
1. ClusterStateRequestでノード情報を取得する
2. NodesInfoRequestでプロセス情報を取得する
3. 各ノードの属性（key-value）をイテレートしてテーブル行を構築する

**画面遷移**：本APIはステートレスなREST APIである。ノード情報API（`GET /_nodes`）で取得できる属性情報のサブセットをテーブル形式で表示する。

**権限による表示制御**：セキュリティプラグインが有効な場合、クラスタモニタリング権限が必要となる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 49 | ノード情報・統計 | 主機能 | カスタムノード属性の情報をテーブル形式で返す処理 |

## 画面種別

一覧（テーブル形式のノード属性表示）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| GET | `/_cat/nodeattrs` | ノード属性情報をテーブル形式で返す |

## 入出力項目

### リクエストパラメータ

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
|-------------|------|------|-----------|------|
| format | string | No | - | レスポンス形式（json, yamlなど） |
| local | boolean | No | false | ローカル情報を返す |
| cluster_manager_timeout | time | No | 30s | クラスタマネージャノードへの接続タイムアウト |
| master_timeout | time | No | 30s | **非推奨**: cluster_manager_timeoutを使用 |
| h | list | No | - | 表示するカラム名のカンマ区切りリスト |
| help | boolean | No | false | ヘルプ情報を返す |
| s | list | No | - | ソートするカラム名のカンマ区切りリスト |
| v | boolean | No | false | 冗長モード。カラムヘッダーを表示 |

## 表示項目

| カラム名 | エイリアス | デフォルト表示 | 説明 |
|---------|-----------|-------------|------|
| node | name | Yes | ノード名 |
| id | nodeId | No | ノードID |
| pid | p | No | プロセスID |
| host | h | Yes | ホスト名 |
| ip | i | Yes | IPアドレス |
| port | po | No | バインドされたトランスポートポート |
| attr | attr.name | Yes | 属性名 |
| value | attr.value | Yes | 属性値 |

## イベント仕様

### 1-GETリクエスト受信

クライアントからのGETリクエストを受信すると、`RestNodeAttrsAction.doCatRequest()` が呼び出される。まずClusterStateRequestを発行してノード一覧を取得し、続いてNodesInfoRequestでプロセス情報を取得する。各ノードのカスタム属性をイテレートし、属性ごとに1行のテーブルデータを生成する。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| GETリクエスト | - | SELECT | 参照のみ。データベースへの更新は発生しない |

## メッセージ仕様

| メッセージ種別 | 条件 | メッセージ内容 |
|--------------|------|-------------|
| 正常応答 | ノード属性取得成功時 | テーブル形式のノード属性情報 |
| エラー | クラスタ未応答時 | 接続エラー |

## 例外処理

- クラスタ状態取得失敗時：接続タイムアウトエラーが返される
- ノード情報取得できない場合：該当ノードのpidがnullとして表示される

## 備考

- 各ノードが複数の属性を持つ場合、1つの属性につき1行出力されるため、行数はノード数 x 属性数となる
- full_idパラメータでノードIDの完全表示が可能（デフォルトは先頭4文字）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | DiscoveryNode.java | `server/src/main/java/org/opensearch/cluster/node/DiscoveryNode.java` | getAttributes()でMap<String, String>を返す |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestNodeAttrsAction.java | `server/src/main/java/org/opensearch/rest/action/cat/RestNodeAttrsAction.java` | Cat NodeAttrs APIのエントリーポイント |

**主要処理フロー**:
1. **行68-69**: `routes()` で `GET /_cat/nodeattrs` を登録
2. **行83-106**: `doCatRequest()` でClusterState -> NodesInfoの2段階リクエスト
3. **行109-122**: `getTableWithHeader()` で8カラムのテーブルヘッダー定義
4. **行124-146**: `buildTable()` でノードごとの属性をイテレートしてテーブル構築

### プログラム呼び出し階層図

```
RestNodeAttrsAction.doCatRequest() [行83]
    |
    +-- ClusterStateRequest (nodes=true) [行84-85]
    |
    +-- client.admin().cluster().state() [行92]
           |
           +-- NodesInfoRequest (PROCESS) [行95-97]
           |
           +-- client.admin().cluster().nodesInfo() [行98]
                  |
                  +-- buildTable() [行124]
                         +-- getTableWithHeader() [行109]
                         +-- node.getAttributes() イテレート [行132]
```

### データフロー図

```
[入力]                  [処理]                         [出力]

GET /_cat/nodeattrs --> RestNodeAttrsAction            --> テーブル形式
                         |
                         v
                    ClusterStateRequest
                         |
                         v
                    DiscoveryNodes (ノード一覧)
                         |
                         v
                    NodesInfoRequest (プロセス情報)
                         |
                         v
                    buildTable() (属性ごとに1行)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RestNodeAttrsAction.java | `server/src/main/java/org/opensearch/rest/action/cat/RestNodeAttrsAction.java` | ソース | Cat NodeAttrs APIのRESTハンドラ |
| AbstractCatAction.java | `server/src/main/java/org/opensearch/rest/action/cat/AbstractCatAction.java` | ソース | Cat API共通基底クラス |
| DiscoveryNode.java | `server/src/main/java/org/opensearch/cluster/node/DiscoveryNode.java` | ソース | ノード情報データ構造 |
| cat.nodeattrs.json | `rest-api-spec/src/main/resources/rest-api-spec/api/cat.nodeattrs.json` | 設定 | REST API仕様定義 |
